/** @file   basecontroller.cpp
 * @brief   Implementation of BaseController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "basecontroller.h" // class's header file
#include "www_map.h"
#include "gameobject.h"
using eng2d::Vec2D;

namespace WeWantWar {




/** Constructor.
 */
BaseController::BaseController( GameObject* pObject ) :
  m_forward( 0 ),
  m_backward( 0 ),
  m_left( 0 ),
  m_right( 0 ),
  m_turn( 0 ),
  m_shoot( 0 ),
  m_counter( -1 ),
  m_pObject( pObject )
{
}




/** Destructor.
 */
BaseController::~BaseController()
{
}


/** Sets the counter-attribute
 */
void BaseController::setCounter( int newCounter )
{
  m_counter = newCounter;
}



/** Resets the controller.
 */
void BaseController::reset()
{
  m_forward = 0;
  m_backward = 0;
  m_left = 0;
  m_right = 0;
  m_turn = 0;
  m_shoot = 0;
  m_counter = -1;
}


} // end of namespace

/**
 * Version history
 * ===============
 * $Log: basecontroller.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:33+02  lamminsa
 * Initial revision
 *
 */
